package com.miam.sdk.components.mealPlanner.form

import com.miam.sdk.components.mealPlanner.form.success.MealPlannerFormSuccessConfig
import com.miam.sdk.components.mealPlanner.form.success.MealPlannerFormSuccessConfigBuilder


class MealPlannerFormConfigBuilder {
    var success: MealPlannerFormSuccessConfig = MealPlannerFormSuccessConfig()

    inline fun success(init: MealPlannerFormSuccessConfigBuilder.() -> Unit) {
        this.success = MealPlannerFormSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): MealPlannerFormConfig {
        return MealPlannerFormConfig(success)
    }
}

