package com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.Divider
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.miam.core.viewModels.product.ProductContract
import com.miam.core.viewModels.product.ProductViewModel
import com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.header.NotInBasketProductHeaderParameters
import com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.notInBasketProducts.NotInBasketProductParameters
import com.miam.sdk.di.TemplateDI
import kotlinx.coroutines.flow.MutableStateFlow


@Composable
fun NotInBasketProducts(
    headerTitle: String,
    notInBasketProducts: MutableStateFlow<List<ProductViewModel>>,
) {

    var expandedState by remember { mutableStateOf(false) }

    fun toggle() {
        expandedState = !expandedState
    }

    val notInBasketProducts by notInBasketProducts.collectAsState()

    Box(modifier = Modifier
        .padding(horizontal = 16.dp)
        .clickable { toggle() }) {
        Column {
            TemplateDI.mealPlanner.basketPreview.success.notInBasketProducts.header.view.Content(
                NotInBasketProductHeaderParameters(
                    title = headerTitle,
                    isExpanded = expandedState,
                    toggle = ::toggle
                )
            )
            if (!expandedState) {
                Divider()
            }
            AnimatedVisibility(visible = expandedState) {
                // TODO can be improve and become a grid
                Column(Modifier.fillMaxWidth()) {
                    for (productVm in notInBasketProducts) {
                        val state = productVm.uiState.collectAsState()
                        state.value.basketEntry?.let { basketEntry ->
                            TemplateDI.mealPlanner.basketPreview.success.notInBasketProducts.product.view.Content(
                                NotInBasketProductParameters(
                                    name = basketEntry.name,
                                    canBeAdd = basketEntry.isUnavailable.not(),
                                    add = { productVm.setEvent(ProductContract.Event.AddProduct) }
                                )
                            )
                        }
                    }
                }
            }
        }
    }
}