package com.miam.sdk.components.mealPlanner.basketPreview.success


import com.miam.sdk.components.mealPlanner.basketPreview.success.found.FoundProductsConfig
import com.miam.sdk.components.mealPlanner.basketPreview.success.found.FoundProductsConfigBuilder
import com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.NotInBasketProductsConfig
import com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.NotInBasketProductsConfigBuilder
import com.miam.sdk.components.mealPlanner.basketPreview.success.recipeRow.MealPlannerBasketPreviewSuccessRecipeRowConfig
import com.miam.sdk.components.mealPlanner.basketPreview.success.recipeRow.MealPlannerBasketPreviewSuccessRecipeRowConfigBuilder

class MealPlannerBasketPreviewSuccessConfigBuilder {

    var recipe: MealPlannerBasketPreviewSuccessRecipeRowConfig = MealPlannerBasketPreviewSuccessRecipeRowConfig()
    var foundProducts: FoundProductsConfig = FoundProductsConfig()
    var notInBasketProducts: NotInBasketProductsConfig = NotInBasketProductsConfig()

    inline fun recipe(init: MealPlannerBasketPreviewSuccessRecipeRowConfigBuilder.() -> Unit) {
        this.recipe = MealPlannerBasketPreviewSuccessRecipeRowConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun foundProducts(init: FoundProductsConfigBuilder.() -> Unit) {
        this.foundProducts = FoundProductsConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun notInBasketProducts(init: NotInBasketProductsConfigBuilder.() -> Unit) {
        this.notInBasketProducts = NotInBasketProductsConfigBuilder()
            .apply(init)
            .build()
    }


    @PublishedApi
    internal fun build(): MealPlannerBasketPreviewSuccessConfig {
        return MealPlannerBasketPreviewSuccessConfig(
            recipe, foundProducts, notInBasketProducts
        )
    }
}