package com.miam.sdk.components.mealPlanner.basketPreview

import com.miam.sdk.components.baseComponent.loader.LoaderConfig
import com.miam.sdk.components.baseComponent.loader.LoaderConfigBuilder
import com.miam.sdk.components.mealPlanner.basketPreview.empty.MealPlannerBasketPreviewEmptyConfig
import com.miam.sdk.components.mealPlanner.basketPreview.empty.MealPlannerBasketPreviewEmptyConfigBuilder
import com.miam.sdk.components.mealPlanner.basketPreview.footer.MealPlannerBasketPreviewFooterConfig
import com.miam.sdk.components.mealPlanner.basketPreview.footer.MealPlannerBasketPreviewFooterConfigBuilder
import com.miam.sdk.components.mealPlanner.basketPreview.success.MealPlannerBasketPreviewSuccessConfig
import com.miam.sdk.components.mealPlanner.basketPreview.success.MealPlannerBasketPreviewSuccessConfigBuilder


class MealPlannerBasketPreviewConfigBuilder {
    var loading: LoaderConfig? = null
    var empty: MealPlannerBasketPreviewEmptyConfig = MealPlannerBasketPreviewEmptyConfig()
    var footer: MealPlannerBasketPreviewFooterConfig = MealPlannerBasketPreviewFooterConfig()
    var success: MealPlannerBasketPreviewSuccessConfig = MealPlannerBasketPreviewSuccessConfig()

    inline fun loading(init: LoaderConfigBuilder.() -> Unit) {
        this.loading = LoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: MealPlannerBasketPreviewEmptyConfigBuilder.() -> Unit) {
        this.empty = MealPlannerBasketPreviewEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun footer(init: MealPlannerBasketPreviewFooterConfigBuilder.() -> Unit) {
        this.footer = MealPlannerBasketPreviewFooterConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun success(init: MealPlannerBasketPreviewSuccessConfigBuilder.() -> Unit) {
        this.success = MealPlannerBasketPreviewSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): MealPlannerBasketPreviewConfig {
        return MealPlannerBasketPreviewConfig(
            loading,
            empty,
            footer,
            success,
        )
    }
}