package com.miam.sdk.components.mealPlanner

import com.miam.sdk.components.mealPlanner.basketPreview.MealPlannerBasketPreviewConfig
import com.miam.sdk.components.mealPlanner.basketPreview.MealPlannerBasketPreviewConfigBuilder
import com.miam.sdk.components.mealPlanner.callToAction.MealPlannerCallToActionConfig
import com.miam.sdk.components.mealPlanner.callToAction.MealPlannerCallToActionConfigBuilder
import com.miam.sdk.components.mealPlanner.form.MealPlannerFormConfig
import com.miam.sdk.components.mealPlanner.form.MealPlannerFormConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.MealPlannerMealsConfig
import com.miam.sdk.components.mealPlanner.meals.MealPlannerMealsConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.recipe.MealPlannerRecipeCardConfig
import com.miam.sdk.components.mealPlanner.meals.recipe.MealPlannerRecipeCardConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.recipe.loading.MealPlannerRecipeLoadingConfig
import com.miam.sdk.components.mealPlanner.meals.recipe.loading.MealPlannerRecipeLoadingConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.recipe.success.placeholder.MealPlannerRecipePlaceholderConfig
import com.miam.sdk.components.mealPlanner.meals.recipe.success.placeholder.MealPlannerRecipePlaceholderConfigBuilder
import com.miam.sdk.components.mealPlanner.recap.MealPlannerRecapConfig
import com.miam.sdk.components.mealPlanner.recap.MealPlannerRecapConfigBuilder
import com.miam.sdk.components.mealPlanner.search.MealPlannerSearchConfig
import com.miam.sdk.components.mealPlanner.search.MealPlannerSearchConfigBuilder
import com.miam.sdk.components.mealPlanner.search.empty.MealPlannerSearchEmptyConfig
import com.miam.sdk.components.mealPlanner.search.empty.MealPlannerSearchEmptyConfigBuilder

class MealPlannerConfigBuilder {

    var recipeCardConfig: MealPlannerRecipeCardConfig = MealPlannerRecipeCardConfig()
    var recipePlaceholderConfig: MealPlannerRecipePlaceholderConfig = MealPlannerRecipePlaceholderConfig()
    var recipeLoadingConfig: MealPlannerRecipeLoadingConfig = MealPlannerRecipeLoadingConfig()
    var callToActionConfig: MealPlannerCallToActionConfig = MealPlannerCallToActionConfig()
    var formConfig: MealPlannerFormConfig = MealPlannerFormConfig()
    var searchConfig: MealPlannerSearchConfig = MealPlannerSearchConfig()
    var searchEmpty: MealPlannerSearchEmptyConfig = MealPlannerSearchEmptyConfig()
    var recapConfig: MealPlannerRecapConfig = MealPlannerRecapConfig()
    var basketPreview: MealPlannerBasketPreviewConfig = MealPlannerBasketPreviewConfig()
    var mealsConfig: MealPlannerMealsConfig = MealPlannerMealsConfig()


    inline fun basketPreview(init: MealPlannerBasketPreviewConfigBuilder.() -> Unit) {
        this.basketPreview = MealPlannerBasketPreviewConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipeCardConfig(init: MealPlannerRecipeCardConfigBuilder.() -> Unit) {
        this.recipeCardConfig = MealPlannerRecipeCardConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipePlaceholderConfig(init: MealPlannerRecipePlaceholderConfigBuilder.() -> Unit) {
        this.recipePlaceholderConfig = MealPlannerRecipePlaceholderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipeLoadingConfig(init: MealPlannerRecipeLoadingConfigBuilder.() -> Unit) {
        this.recipeLoadingConfig = MealPlannerRecipeLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun callToActionConfig(init: MealPlannerCallToActionConfigBuilder.() -> Unit) {
        this.callToActionConfig = MealPlannerCallToActionConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun formConfig(init: MealPlannerFormConfigBuilder.() -> Unit) {
        this.formConfig = MealPlannerFormConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun searchEmpty(init: MealPlannerSearchEmptyConfigBuilder.() -> Unit) {
        this.searchEmpty = MealPlannerSearchEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recapConfig(init: MealPlannerRecapConfigBuilder.() -> Unit) {
        this.recapConfig = MealPlannerRecapConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun searchConfig(init: MealPlannerSearchConfigBuilder.() -> Unit) {
        this.searchConfig = MealPlannerSearchConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun mealsConfig(init: MealPlannerMealsConfigBuilder.() -> Unit) {
        this.mealsConfig = MealPlannerMealsConfigBuilder()
            .apply(init)
            .build()
    }


    @PublishedApi
    internal fun build(): MealPlannerConfig {
        return MealPlannerConfig(
            basketPreview,
            recipeCardConfig,
            recipePlaceholderConfig,
            recipeLoadingConfig,
            callToActionConfig,
            mealsConfig,
            formConfig,
            searchEmpty,
            searchConfig,
            recapConfig
        )
    }
}