package com.miam.sdk.components.catalog.success.categoriesPage.category

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.foundation.lazy.items
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.style.TextDecoration
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.core.model.Recipe
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.sdk.components.recipeJourney.RecipeJourney

class CatalogCategoriesPageCategoryImp: CatalogCategoriesPageCategory {
    @Composable
    override fun Content(param: CatalogCategoriesPageCategoryParameters) {
        Column {
            Row(
                Modifier
                    .fillMaxWidth()
                    .padding(8.dp)
            ) {
                Column {
                    param.category.attributes?.title?.let {
                        Text(
                            text = it,
                            color = Colors.black,
                            style = Typography.subtitleBold
                        )
                    }
                    param.category.subtitle?.let {
                        Text(
                            text = it,
                            color = Colors.black,
                            modifier = Modifier.padding(top = 4.dp)
                        )
                    }
                }
            }
            Row(
                Modifier
                    .fillMaxWidth()
                    .padding(8.dp)
                    .clickable { param.goToCategoryPage(param.category) },
                horizontalArrangement = Arrangement.End
            ) {
                Text(
                    text = Localisation.Catalog.showAll.localised,
                    style = TextStyle(textDecoration = TextDecoration.Underline),
                    color = Colors.primary
                )
            }
            LazyRow(horizontalArrangement = Arrangement.spacedBy(4.dp)) {
                items(
                    key = { item: Recipe -> item.id },
                    items = (param.category.relationships?.recipes?.data ?: emptyList())
                ) { recipe ->
                    Box(
                        modifier = Modifier
                            .width(350.dp)
                            .height(380.dp)
                    ) {
                        RecipeJourney.View(recipe = recipe)
                    }
                }
            }
        }
    }
}