package com.miam.sdk.components.baseComponent.recipesPage

import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfig
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfigBuilder
import com.miam.sdk.components.baseComponent.loader.LoaderConfig
import com.miam.sdk.components.baseComponent.loader.LoaderConfigBuilder
import com.miam.sdk.components.baseComponent.recipesPage.success.RecipesPageSuccessConfig
import com.miam.sdk.components.baseComponent.recipesPage.success.RecipesPageSuccessConfigBuilder

class RecipesPageConfigBuilder {

    var success: RecipesPageSuccessConfig = RecipesPageSuccessConfig()
    var loading: LoaderConfig? = null
    var empty: EmptyPageConfig? = null

    inline fun success(init: RecipesPageSuccessConfigBuilder.() -> Unit) {
        this.success = RecipesPageSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loading(init: LoaderConfigBuilder.() -> Unit) {
        this.loading = LoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: EmptyPageConfigBuilder.() -> Unit) {
        this.empty = EmptyPageConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): RecipesPageConfig {
        return RecipesPageConfig(success, loading, empty)
    }
}