package com.miam.sdk.components.baseComponent.likeButton

import androidx.compose.foundation.shape.CircleShape
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.graphics.Shape
import com.miam.core.viewModels.recipeLike.LikeButtonViewModelFactory
import com.miam.sdk.components.baseComponent.ManagementResourceState
import com.miam.sdk.components.baseComponent.likeButton.success.LikeButtonSuccessParameters
import com.miam.sdk.di.TemplateDI

class LikeButton(
    private val backgroundShape: Shape = CircleShape,
    private val recipeId: String,
    Content: (@Composable (action: () -> Unit) -> Unit)? = null
) {

    private val likeButtonViewModel = LikeButtonViewModelFactory().instantiate(recipeId)

    @Composable
    fun Content() {
        DisposableEffect(Unit) { onDispose { LikeButtonViewModelFactory().abolishInstance(recipeId) } }
        val state by likeButtonViewModel.uiState.collectAsState()

        ManagementResourceState(
            resourceState = state.isLiked,
            successView = { isLiked ->
                requireNotNull(isLiked)
                TemplateDI.likeButton.success.view.Content(param = LikeButtonSuccessParameters(
                    isLiked = isLiked,
                    likeAction = { likeButtonViewModel.toggleLike() }
                ))
            },
            loadingView = {
                TemplateDI.likeButton.loading.view.Content()
            },
            emptyView = null // There is no empty state for this component
        )
    }
}