package com.miam.kmm_miam_sdk.android.ui.components.routerOutlet


import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.Scaffold
import androidx.compose.material.Text
import androidx.compose.runtime.*
import androidx.compose.ui.Alignment
import androidx.compose.ui.ExperimentalComposeUiApi
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.rotate
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import androidx.compose.ui.window.Dialog
import androidx.compose.ui.window.DialogProperties
import com.miam.core.di.MiamDI
import com.miam.core.services.RouteService
import com.miam.core.viewModels.itemSelector.ItemSelectorViewModel
import com.miam.core.viewModels.recipe.RecipeViewModel
import com.miam.core.viewModels.router.RouterContent
import com.miam.core.viewModels.router.RouterOutletContract
import com.miam.core.viewModels.router.RouterOutletViewModel
import com.miam.kmm_miam_sdk.android.ressource.Image.toggleCaret
import com.miam.kmm_miam_sdk.android.theme.Dimension.lPadding
import com.miam.kmm_miam_sdk.android.theme.Dimension.mPadding
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable
import com.miam.sdk.components.itemSelector.ItemSelector
import com.miam.sdk.components.sponsorDetail.SponsorDetail

class RouterOutlet {

    private var vmRouter: RouterOutletViewModel = RouterOutletViewModel()

    //TODO FIx
    private val itemSelectorViewModel: ItemSelectorViewModel = ItemSelectorViewModel()
    private val routeService: RouteService by lazy { MiamDI.routeService }

    fun getViewModel(): RouterOutletViewModel {
        return vmRouter
    }

    fun goToDetail(vmRecipe: RecipeViewModel, showDetailsFooter: Boolean = true) {
        vmRouter.setEvent(RouterOutletContract.Event.GoToDetail(vmRecipe, showDetailsFooter))
    }

    fun goToPreview(recipeId: String, vmRecipe: RecipeViewModel) {
        vmRouter.setEvent(RouterOutletContract.Event.GoToPreview(recipeId = recipeId, vm = vmRecipe))
    }

    fun goToReplaceItem() {

        vmRouter.setEvent(
            RouterOutletContract.Event.GoToItemSelector
        )
    }

    @OptIn(ExperimentalComposeUiApi::class)
    @Composable
    fun Content() {
        val state by vmRouter.uiState.collectAsState()

        if (state.isOpen) {
            Dialog(
                onDismissRequest = { routeService.previous() },
                properties = DialogProperties(usePlatformDefaultWidth = false)
            ) {
                FullScreenContent(
                    { routeService.onCloseDialog() },
                    { routeService.previous() },
                    { goToReplaceItem() },
                    { goToDetail(it) },
                    state,
                    vmRouter
                )
            }
        }
    }
}

@Composable
fun EmptyView(close: () -> Unit) {
    Scaffold(
        topBar = {
            Row(
                horizontalArrangement = Arrangement.SpaceBetween,
                verticalAlignment = Alignment.CenterVertically,
                modifier = Modifier.padding(horizontal = lPadding),
            ) {
                Clickable(
                    onClick = { close() },
                ) {
                    Image(
                        painter = painterResource(toggleCaret),
                        contentDescription = "close button",
                        modifier = Modifier
                            .size(40.dp)
                            .padding(end = mPadding)
                            .rotate(180f)
                    )
                }
            }
        },
        content = { padding ->
            Text(modifier = Modifier.padding(padding), text = "Une erreur s'est produite, veuillez réessayer", textAlign = TextAlign.Center)
        }
    )
}

@Composable
fun FullScreenContent(
    close: () -> Unit,
    previous: () -> Unit,
    goToReplaceItem: () -> Unit,
    goToDetail: (RecipeViewModel) -> Unit,
    state: RouterOutletContract.State,
    vmRouter: RouterOutletViewModel
) {
    Box {
        when (state.content) {
            RouterContent.RECIPE_DETAIL -> state.rvm?.let {
                //RecipeDetails(it, vmRouter, close)
            }

            RouterContent.BASKET_PREVIEW -> state.rvm?.let { rvm ->
              
            }

            RouterContent.RECIPE_SPONSOR -> {
                state.sponsor?.let {
                    SponsorDetail(context = LocalContext.current).apply { bind(it, previous) }.Content()
                }
            }

            RouterContent.ITEMS_SELECTOR -> ItemSelector(context = LocalContext.current).Content()
            RouterContent.EMPTY -> EmptyView(close)
            else -> {
                EmptyView(close)
            }
        }
    }
}
