package com.miam.sdk.di

import com.miam.sdk.components.TemplatesConfigs
import com.miam.sdk.components.baseComponent.DefaultViewsConfig
import com.miam.sdk.components.baseComponent.filter.FilterConfig
import com.miam.sdk.components.baseComponent.likeButton.LikeButtonConfig
import com.miam.sdk.components.baseComponent.myMealButton.MyMealButtonConfig
import com.miam.sdk.components.baseComponent.recipesPage.RecipesPageConfig
import com.miam.sdk.components.catalog.CatalogConfig
import com.miam.sdk.components.favoritePage.FavoritePageConfig
import com.miam.sdk.components.itemSelector.ItemSelectorConfig
import com.miam.sdk.components.mealPlanner.MealPlannerConfig
import com.miam.sdk.components.mealPlanner.callToAction.MealPlannerCallToActionConfig
import com.miam.sdk.components.myMeal.MyMealConfig
import com.miam.sdk.components.preferences.PreferencesConfig
import com.miam.sdk.components.price.PriceConfig
import com.miam.sdk.components.recipeCard.RecipeCardConfig
import com.miam.sdk.components.recipeCarousel.RecipeCarouselConfig
import com.miam.sdk.components.recipeDetail.RecipeDetailConfig
import com.miam.sdk.components.sponsorDetail.SponsorDetailConfig
import com.miam.sdk.components.tag.BasketTagConfig


object TemplateDI {
    private val templates: TemplatesConfigs by lazy { TemplatesConfigs.getInstance() }
    internal val itemSelector: ItemSelectorConfig by lazy { templates.itemSelector }
    internal val likeButton: LikeButtonConfig by lazy { templates.likeButton }
    internal val mealPlanner: MealPlannerConfig by lazy { templates.mealPlanner }
    internal val catalog: CatalogConfig by lazy { templates.catalog }
    internal val favoritePage: FavoritePageConfig by lazy { templates.favoritePage }
    public val recipeDetail: RecipeDetailConfig by lazy { templates.recipeDetail }
    internal val preferences: PreferencesConfig by lazy { templates.preferences }
    internal val basketTag: BasketTagConfig by lazy { templates.basketTag }
    internal val recipeCard: RecipeCardConfig by lazy { templates.recipeCard }
    internal val mealPlannerCallToAction: MealPlannerCallToActionConfig by lazy { templates.mealPlannerCallToAction }
    internal val myMeal: MyMealConfig by lazy { templates.myMeal }
    internal val myMealButton: MyMealButtonConfig by lazy { templates.myMealButton }
    internal val sponsorDetail: SponsorDetailConfig by lazy { templates.sponsorDetail }
    internal val recipesPage: RecipesPageConfig by lazy { templates.recipesPage }
    internal val filter: FilterConfig by lazy { templates.filter }
    internal val price: PriceConfig by lazy { templates.price }
    internal val recipeCarousel: RecipeCarouselConfig by lazy { templates.recipeCarousel }
    internal val defaultViews: DefaultViewsConfig by lazy { templates.defaultViews }
}