package com.miam.sdk.components.recipeDetail.success.sponsorBanner

import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.heightIn
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.Divider
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.unit.dp
import coil.compose.AsyncImage
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography

class RecipeDetailSponsorBannerImp: RecipeDetailSponsorBanner {
    @Composable
    override fun Content(params: RecipeDetailSponsorBannerParameters) {
        Column {
            Row(
                Modifier
                    .background(Color.Transparent)
                    .padding(16.dp)
                    .fillMaxWidth(),
                Arrangement.SpaceBetween
            ) {
                Column(Modifier.fillMaxWidth(0.7f)) {
                    Text(text = Localisation.SponsorBanner.sponsorBannerSpeach.localised, style = Typography.body)
                    Spacer(Modifier.size(4.dp))
                    Text(
                        text = Localisation.SponsorBanner.sponsorBannerMoreInfo.localised,
                        style = Typography.link,
                        color = Colors.primary,
                        modifier = Modifier.clickable { params.openSponsorDetail(params.sponsor) })
                }
                params.sponsor.attributes?.let {
                    AsyncImage(
                        modifier = Modifier
                            .heightIn(0.dp, 96.dp),
                        model = it.logoUrl,
                        contentDescription = null,
                        contentScale = ContentScale.Inside,
                    )
                }
            }
            Divider()
        }
    }
}