package com.miam.sdk.components.recipeDetail.success.productListHeader

import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography

class RecipeDetailProductListHeaderImp: RecipeDetailProductListHeader {
    @Composable
    override fun Content(params: RecipeDetailProductListHeaderParameters) {
        Text(
            modifier = Modifier
                .padding(16.dp)
                .fillMaxWidth(),
            text = Localisation.Recipe.numberOfIngredients(params.productCount).localised,
            style = Typography.subtitleBold.copy(textAlign = TextAlign.Start),
            color = Colors.black
        )
    }
}