package com.miam.sdk.components.preferences

import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfig
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfigBuilder
import com.miam.sdk.components.baseComponent.loader.LoaderConfig
import com.miam.sdk.components.baseComponent.loader.LoaderConfigBuilder
import com.miam.sdk.components.preferences.search.PreferencesSearchConfig
import com.miam.sdk.components.preferences.search.PreferencesSearchConfigBuilder
import com.miam.sdk.components.preferences.success.PreferencesSuccessConfig
import com.miam.sdk.components.preferences.success.PreferencesSuccessConfigBuilder

class PreferencesConfigBuilder {

    var loader: LoaderConfig? = null
    var empty: EmptyPageConfig? = null
    var success: PreferencesSuccessConfig = PreferencesSuccessConfig()
    var search: PreferencesSearchConfig = PreferencesSearchConfig()

    inline fun loader(init: LoaderConfigBuilder.() -> Unit) {
        this.loader = LoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: EmptyPageConfigBuilder.() -> Unit) {
        this.empty = EmptyPageConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun success(init: PreferencesSuccessConfigBuilder.() -> Unit) {
        this.success = PreferencesSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun search(init: PreferencesSearchConfigBuilder.() -> Unit) {
        this.search = PreferencesSearchConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): PreferencesConfig {
        return PreferencesConfig(loader, empty, success, search)
    }
}