package com.miam.sdk.components.mealPlanner.recap

import android.content.Context
import android.util.AttributeSet
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.core.viewModels.mealPlanner.recap.MealPlannerRecapViewModel
import com.miam.sdk.components.mealPlanner.recap.success.MealPlannerRecapParameters
import com.miam.sdk.di.TemplateDI

class MealPlannerRecap @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    private val recapVM = MealPlannerRecapViewModel()

    var action: () -> Unit = {}

    @Composable
    override fun Content() {
        val state = recapVM.uiState.collectAsState()

        TemplateDI.mealPlanner.recap.view.Content(
            mealPlannerRecapParameters =
            MealPlannerRecapParameters(
                state.value.numberOfMeals,
                state.value.totalPrice,
            ) { action() }
        )
    }
}
