package com.miam.sdk.components.baseComponent.errorPage

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.size
import androidx.compose.material.OutlinedButton
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography

class ErrorPageImp: ErrorPage {
    @Composable
    override fun Content(params: ErrorPageParameters) {
        Column(
            modifier = Modifier.fillMaxSize(),
            horizontalAlignment = Alignment.CenterHorizontally,
            verticalArrangement = Arrangement.Center
        ) {
            Text(
                text = params.errorText,
                style = Typography.subtitle
            )
            Spacer(modifier = Modifier.size(10.dp))
            OutlinedButton(onClick = params.action) {
                Text(
                    text = params.actionText,
                    style = Typography.body,
                    color = Colors.primary
                )
            }
        }
    }
}

@Preview(showBackground = true, name = "ErrorPage - Default Error")
@Composable
fun ErrorPageDefaultPreview() {
    val mockErrorPageDefaultParams = ErrorPageParameters(
        action = {}
    )
    ErrorPageImp().Content(params = mockErrorPageDefaultParams)
}

@Preview(showBackground = true, name = "ErrorPage - Custom Error")
@Composable
fun ErrorPageCustomPreview() {
    val mockErrorPageParams = ErrorPageParameters(
        errorText = "An error has occurred.",
        actionText = "Retry",
        action = {}
    )
    ErrorPageImp().Content(params = mockErrorPageParams)
}
