package com.miam.sdk.components.baseComponent

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import com.miam.kmm_miam_sdk.android.ui.components.states.Empty
import com.miam.kmm_miam_sdk.android.ui.components.states.Error
import com.miam.core.base.mvi.BasicUiState

@Composable
fun <T> ManagementResourceState(
    resourceState: BasicUiState<T>,
    successView: @Composable (data: T?) -> Unit,
    loadingView: (@Composable () -> Unit)? = null,
    emptyView: (@Composable () -> Unit)? = null,
    errorView: (@Composable () -> Unit)? = null,
    idleView: (@Composable () -> Unit) = {}
) {
    Column(
        verticalArrangement = Arrangement.Center,
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        when (resourceState) {
            is BasicUiState.Empty -> if (emptyView != null) emptyView() else Empty()
            is BasicUiState.Error -> if (errorView != null) errorView() else Error(onTryAgain = {})
            BasicUiState.Loading -> if (loadingView != null) loadingView() else Empty()
            BasicUiState.Idle -> idleView()
            is BasicUiState.Success -> {
                successView(resourceState.data)
            }
        }
    }
}