package com.miam.sdk.components.preferences.success.guestSection

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.sdk.components.baseComponent.counter.CounterParameters
import com.miam.sdk.di.TemplateDI

class PreferencesGuestSectionImp: PreferencesGuestSection {

    @Composable
    override fun Content(params: PreferencesGuestSectionParameters) {
        Row(
            Modifier.fillMaxWidth(),
            horizontalArrangement = Arrangement.SpaceBetween,
            verticalAlignment = Alignment.CenterVertically
        ) {
            Text(text = Localisation.Preferences.numberOfGuests.localised, style = Typography.bodyBold)

            TemplateDI.preferences.success.counter?.view?.Content(
                params = CounterParameters(
                    initialCount = params.guests,
                    isDisable = false,
                    onCounterChanged = { params.guestChanged(it) },
                    minValue = 1,
                    maxValue = 99
                )
            ) ?: TemplateDI.defaultViews.counter?.view?.Content(
                params = CounterParameters(
                    initialCount = params.guests,
                    isDisable = false,
                    onCounterChanged = { params.guestChanged(it) },
                    minValue = 1,
                    maxValue = 99
                )
            )
        }
    }
}