package com.miam.sdk.components.preferences.success.footer

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable

class PreferencesFooterImp: PreferencesFooter {

    @Composable
    override fun Content(params: PreferencesFooterParameters) {
        Row(
            modifier = Modifier
                .fillMaxWidth()
                .height(60.dp)
                .background(
                    color = Colors.white,
                    shape = RoundedCornerShape(topStart = 40.dp, topEnd = 40.dp)
                ),
            horizontalArrangement = Arrangement.SpaceEvenly,
            verticalAlignment = Alignment.CenterVertically
        ) {
            Clickable(onClick = { params.closePref() }) {
                Box(
                    Modifier
                        .border(BorderStroke(1.dp, Color.Gray), RoundedCornerShape(50))
                        .background(Colors.white)
                ) {
                    Row(Modifier.padding(horizontal = 16.dp, vertical = 8.dp)) {
                        Text(
                            text = Localisation.Preferences.cancel.localised,
                            style = Typography.subtitle.copy(fontWeight = FontWeight.Bold),
                            color = Color.Black
                        )
                    }
                }
            }
            Clickable(onClick = { params.applyPref() }) {
                Box(
                    Modifier
                        .clip(RoundedCornerShape(50))
                        .background(Colors.primary)
                        .border(BorderStroke(1.dp, Colors.primary), RoundedCornerShape(50))
                ) {
                    Row(
                        Modifier
                            .padding(horizontal = 16.dp, vertical = 8.dp)

                    ) {
                        Text(
                            text = Localisation.Catalog.showResults(params.recipesFound).localised,
                            style = Typography.subtitle.copy(fontWeight = FontWeight.Bold),
                            color = Colors.white
                        )
                    }
                }
            }
        }
    }
}