package com.miam.sdk.components.mealPlanner.recipe


import android.content.Context
import android.util.AttributeSet
import androidx.compose.foundation.layout.Box
import androidx.compose.runtime.Composable
import com.miam.core.data.repository.BudgetRepository
import com.miam.core.model.Recipe
import com.miam.core.viewModels.recipe.RecipeViewModel
import com.miam.sdk.components.baseComponent.recipeCard.BaseRecipeCard
import com.miam.sdk.components.mealPlanner.recipe.loading.MealPlannerRecipeLoadingParameters
import com.miam.sdk.components.mealPlanner.recipe.success.MealPlannerRecipeCardParameters
import com.miam.sdk.components.recipeJourney.RecipeJourney
import com.miam.sdk.di.TemplateDI

class MealPlannerRecipeCard @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): BaseRecipeCard(context, attrs, defStyleAttr) {

    internal var index: Int = 0
        set(value) {
            field = value
        }
    internal var isInSearchPage = false
        set(value) {
            field = value
        }
    internal var price: Double = 0.0
    internal var changeAction = {}
        set(value) {
            field = value
        }
    internal var replaceAction = { }
        set(value) {
            field = value
        }
    internal var deleteAction = {}
        set(value) {
            field = value
        }

    override val vmRecipe: RecipeViewModel = RecipeViewModel()

    @Composable
    override fun SuccessView(recipe: Recipe) {

        RecipeJourney.View(recipe = recipe, cookOnlyMode = true) { recipeId, goToDetail ->
            TemplateDI.mealPlanner.recipeCard.view.Content(
                mealPlannerRecipeCardParameters = MealPlannerRecipeCardParameters(
                    index = index,
                    isInSearchPage = isInSearchPage,
                    isAlreadyInBasket = vmRecipe.currentState.isInCart,
                    guest = BudgetRepository.guestCount,
                    price = price,
                    recipe = recipe,
                    changeAction = changeAction,
                    replaceAction = replaceAction,
                    deleteAction = deleteAction,
                    openDetail = { goToDetail(recipeId) }
                ))
        }
    }

    @Composable
    override fun LoadingView() {
        TemplateDI.mealPlanner.recipeLoading.view.Content(
            mealPlannerRecipeLoadingParameters = MealPlannerRecipeLoadingParameters()
        )
    }

    @Composable
    override fun EmptyView() {
        Box {}
    }
}
