package com.miam.sdk.components.catalog.success

import com.miam.sdk.components.baseComponent.filter.success.FilterSuccessConfig
import com.miam.sdk.components.baseComponent.filter.success.FilterSuccessConfigBuilder
import com.miam.sdk.components.catalog.success.categoriesPage.CatalogCategoriesPageConfig
import com.miam.sdk.components.catalog.success.categoriesPage.CatalogCategoriesPageConfigBuilder
import com.miam.sdk.components.catalog.success.floating.CatalogFloatingConfig
import com.miam.sdk.components.catalog.success.floating.CatalogFloatingConfigBuilder
import com.miam.sdk.components.catalog.success.search.CatalogSuccessSearchConfig
import com.miam.sdk.components.catalog.success.search.CatalogSuccessSearchConfigBuilder
import com.miam.sdk.components.catalog.success.toolbar.CatalogSuccessToolbarConfig
import com.miam.sdk.components.catalog.success.toolbar.CatalogSuccessToolbarConfigBuilder


class CatalogSuccessConfigBuilder {

    var categories: CatalogCategoriesPageConfig = CatalogCategoriesPageConfig()
    var search: CatalogSuccessSearchConfig = CatalogSuccessSearchConfig()
    var filter: FilterSuccessConfig = FilterSuccessConfig()
    var toolbar: CatalogSuccessToolbarConfig = CatalogSuccessToolbarConfig()
    var floating: CatalogFloatingConfig = CatalogFloatingConfig()

    inline fun categories(init: CatalogCategoriesPageConfigBuilder.() -> Unit) {
        categories = CatalogCategoriesPageConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun search(init: CatalogSuccessSearchConfigBuilder.() -> Unit) {
        search = CatalogSuccessSearchConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun filter(init: FilterSuccessConfigBuilder.() -> Unit) {
        filter = FilterSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun floating(init: CatalogFloatingConfigBuilder.() -> Unit) {
        floating = CatalogFloatingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun toolbar(init: CatalogSuccessToolbarConfigBuilder.() -> Unit) {
        toolbar = CatalogSuccessToolbarConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): CatalogSuccessConfig {
        return CatalogSuccessConfig(categories, search, filter, floating, toolbar)
    }
}