package com.miam.sdk.components.baseComponent.filter

import com.miam.sdk.components.baseComponent.filter.success.FilterSuccessConfig
import com.miam.sdk.components.baseComponent.filter.success.FilterSuccessConfigBuilder

class FilterConfigBuilder {
    var success: FilterSuccessConfig = FilterSuccessConfig()

    inline fun success(init: FilterSuccessConfigBuilder.() -> Unit) {
        this.success = FilterSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): FilterConfig {
        return FilterConfig(success)
    }
}