package com.miam.sdk.components.recipeDetail.success.swapper

import androidx.compose.animation.ExperimentalAnimationApi
import androidx.compose.animation.animateContentSize
import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.ExperimentalTextApi
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors

class SwapperImp: Swapper {

    @OptIn(ExperimentalAnimationApi::class, ExperimentalTextApi::class)
    @Composable
    override fun Content(params: SwapperParameters) {

        var isShopping by remember { mutableStateOf(params.isShopping) }

        Box(
            Modifier
                .fillMaxWidth()
                .padding(horizontal = 16.dp)
                .clickable {
                    isShopping = !isShopping
                    params.toggle()
                }) {

            Row(
                Modifier
                    .fillMaxWidth()
                    .background(
                        color = Colors.backgroundGrey,
                        shape = RoundedCornerShape(100.dp),
                    )
                    .height(48.dp),
                verticalAlignment = Alignment.CenterVertically
            ) {}


            Row(
                Modifier
                    .fillMaxWidth()
                    .height(48.dp),
                Arrangement.Start,
                verticalAlignment = Alignment.CenterVertically,

                ) {

                Spacer(
                    modifier = Modifier
                        .animateContentSize()
                        .then(if (isShopping) Modifier.weight(1f) else Modifier.height(0.dp))
                )
                Surface(
                    shape = RoundedCornerShape(100.dp),
                    color = Colors.primary,
                    modifier = Modifier
                        .weight(1f)
                        .height(44.dp)
                        .padding(vertical = 2.dp, horizontal = 4.dp)
                ) {}
                Spacer(
                    modifier = Modifier
                        .animateContentSize()
                        .then(if (isShopping) Modifier.height(0.dp) else Modifier.weight(1f))
                )
            }

            Row(
                Modifier
                    .fillMaxWidth()
                    .height(48.dp),
                verticalAlignment = Alignment.CenterVertically
            ) {
                Text(
                    text = Localisation.RecipeDetails.shopping.localised,
                    style = TextStyle(
                        color = if (isShopping) Colors.boldText else Colors.white,
                        fontSize = 16.sp,
                        textAlign = TextAlign.Center,
                        fontWeight = FontWeight.Bold
                    ),
                    modifier = Modifier
                        .weight(1f)

                )
                Text(
                    text = Localisation.RecipeDetails.cooking.localised,
                    style = TextStyle(
                        color = if (isShopping) Colors.white else Colors.boldText,
                        fontSize = 16.sp,
                        textAlign = TextAlign.Center,
                        fontWeight = FontWeight.Bold
                    ),
                    modifier = Modifier.weight(1f)
                )
            }
        }
    }
}