package com.miam.sdk.components.recipeDetail.success.header

import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material.Surface
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.rotate
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors

class RecipeDetailHeaderImp: RecipeDetailHeader {
    @Composable
    override fun Content(params: RecipeDetailHeaderParameters) {
        Row(
            horizontalArrangement = Arrangement.SpaceBetween,
            verticalAlignment = Alignment.CenterVertically,
            modifier = Modifier.background(color = Color.Transparent)
        ) {
            Box(Modifier.padding(16.dp)) {
                Surface(
                    Modifier
                        .size(36.dp)
                        .align(Alignment.Center),
                    shape = CircleShape,
                    color = Colors.white,
                    elevation = 1.dp
                ) {}
                Image(
                    painter = painterResource(Image.toggleCaret),
                    contentDescription = null,
                    modifier = Modifier
                        .align(Alignment.Center)
                        .size(24.dp).padding(end = 4.dp)
                        .rotate(180f)
                        .clickable { params.closeDialogue() }
                )
            }
        }
    }
}