package com.miam.sdk.components.recipeDetail.success

import com.miam.sdk.components.recipeDetail.success.footer.RecipeDetailSuccessFooterConfig
import com.miam.sdk.components.recipeDetail.success.footer.RecipeDetailSuccessFooterConfigBuilder
import com.miam.sdk.components.recipeDetail.success.header.RecipeDetailHeaderConfig
import com.miam.sdk.components.recipeDetail.success.header.RecipeDetailHeaderConfigBuilder
import com.miam.sdk.components.recipeDetail.success.info.RecipeDetailInfoConfig
import com.miam.sdk.components.recipeDetail.success.info.RecipeDetailInfoConfigBuilder
import com.miam.sdk.components.recipeDetail.success.ingredients.IngredientsConfig
import com.miam.sdk.components.recipeDetail.success.ingredients.IngredientsConfigBuilder
import com.miam.sdk.components.recipeDetail.success.oftenDeleted.OftenDeletedProductsConfig
import com.miam.sdk.components.recipeDetail.success.oftenDeleted.OftenDeletedProductsConfigBuilder
import com.miam.sdk.components.recipeDetail.success.product.ProductConfig
import com.miam.sdk.components.recipeDetail.success.product.ProductConfigBuilder
import com.miam.sdk.components.recipeDetail.success.productListHeader.RecipeDetailProductListHeaderConfig
import com.miam.sdk.components.recipeDetail.success.productListHeader.RecipeDetailProductListHeaderConfigBuilder
import com.miam.sdk.components.recipeDetail.success.sponsorBanner.RecipeDetailSponsorBannerConfig
import com.miam.sdk.components.recipeDetail.success.sponsorBanner.RecipeDetailSponsorBannerConfigBuilder
import com.miam.sdk.components.recipeDetail.success.steps.RecipeDetailStepsConfig
import com.miam.sdk.components.recipeDetail.success.steps.RecipeDetailStepsConfigBuilder
import com.miam.sdk.components.recipeDetail.success.swapper.SwapperConfig
import com.miam.sdk.components.recipeDetail.success.swapper.SwapperConfigBuilder
import com.miam.sdk.components.recipeDetail.success.tag.RecipeDetailSuccessTagConfig
import com.miam.sdk.components.recipeDetail.success.tag.RecipeDetailSuccessTagConfigBuilder
import com.miam.sdk.components.recipeDetail.success.unavailable.UnavailableProductsConfig
import com.miam.sdk.components.recipeDetail.success.unavailable.UnavailableProductsConfigBuilder

class RecipeDetailSuccessConfigBuilder {
    var info: RecipeDetailInfoConfig = RecipeDetailInfoConfig()
    var ingredients: IngredientsConfig = IngredientsConfig()
    var oftenDeleted: OftenDeletedProductsConfig = OftenDeletedProductsConfig()
    var steps: RecipeDetailStepsConfig = RecipeDetailStepsConfig()
    var sponsorBanner: RecipeDetailSponsorBannerConfig = RecipeDetailSponsorBannerConfig()
    var header: RecipeDetailHeaderConfig = RecipeDetailHeaderConfig()
    var footer: RecipeDetailSuccessFooterConfig = RecipeDetailSuccessFooterConfig()
    var swapper: SwapperConfig = SwapperConfig()
    var tag: RecipeDetailSuccessTagConfig = RecipeDetailSuccessTagConfig()
    var products: ProductConfig = ProductConfig()
    var unavailable: UnavailableProductsConfig = UnavailableProductsConfig()
    var productListHeader: RecipeDetailProductListHeaderConfig = RecipeDetailProductListHeaderConfig()
    var gapBetweenProducts: Int = 8

    inline fun info(init: RecipeDetailInfoConfigBuilder.() -> Unit) {
        this.info = RecipeDetailInfoConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun ingredients(init: IngredientsConfigBuilder.() -> Unit) {
        this.ingredients = IngredientsConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun products(init: ProductConfigBuilder.() -> Unit) {
        this.products = ProductConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun steps(init: RecipeDetailStepsConfigBuilder.() -> Unit) {
        this.steps = RecipeDetailStepsConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun sponsorBanner(init: RecipeDetailSponsorBannerConfigBuilder.() -> Unit) {
        this.sponsorBanner = RecipeDetailSponsorBannerConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun header(init: RecipeDetailHeaderConfigBuilder.() -> Unit) {
        this.header = RecipeDetailHeaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun footer(init: RecipeDetailSuccessFooterConfigBuilder.() -> Unit) {
        this.footer = RecipeDetailSuccessFooterConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun swapper(init: SwapperConfigBuilder.() -> Unit) {
        this.swapper = SwapperConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun tag(init: RecipeDetailSuccessTagConfigBuilder.() -> Unit) {
        this.tag = RecipeDetailSuccessTagConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun oftenDeleted(init: OftenDeletedProductsConfigBuilder.() -> Unit) {
        this.oftenDeleted = OftenDeletedProductsConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun unavailable(init: UnavailableProductsConfigBuilder.() -> Unit) {
        this.unavailable = UnavailableProductsConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun productListHeader(init: RecipeDetailProductListHeaderConfigBuilder.() -> Unit) {
        this.productListHeader = RecipeDetailProductListHeaderConfigBuilder()
            .apply(init)
            .build()
    }


    @PublishedApi
    internal fun build(): RecipeDetailSuccessConfig {
        return RecipeDetailSuccessConfig(
            info,
            ingredients,
            products,
            gapBetweenProducts,
            productListHeader,
            oftenDeleted,
            unavailable,
            steps,
            sponsorBanner,
            header,
            footer,
            swapper,
            tag
        )
    }
}