package com.miam.sdk.components.recipeCarousel

import com.miam.sdk.components.recipeCarousel.empty.RecipeCarouselEmptyConfig
import com.miam.sdk.components.recipeCarousel.empty.RecipeCarouselEmptyConfigBuilder
import com.miam.sdk.components.recipeCarousel.loader.RecipeCarouselLoaderConfig
import com.miam.sdk.components.recipeCarousel.loader.RecipeCarouselLoaderConfigBuilder

class RecipeCarouselConfigBuilder {

    var empty: RecipeCarouselEmptyConfig = RecipeCarouselEmptyConfig()
    var loader: RecipeCarouselLoaderConfig = RecipeCarouselLoaderConfig()

    inline fun loader(init: RecipeCarouselLoaderConfigBuilder.() -> Unit) {
        this.loader = RecipeCarouselLoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: RecipeCarouselEmptyConfigBuilder.() -> Unit) {
        this.empty = RecipeCarouselEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): RecipeCarouselConfig {
        return RecipeCarouselConfig(loader, empty)
    }
}