package com.miam.sdk.components.price.footer

import com.miam.sdk.components.price.footer.empty.FooterEmptyPriceConfig
import com.miam.sdk.components.price.footer.empty.FooterEmptyPriceConfigBuilder
import com.miam.sdk.components.price.footer.loading.FooterLoadingPriceConfig
import com.miam.sdk.components.price.footer.loading.FooterLoadingPriceConfigBuilder
import com.miam.sdk.components.price.footer.success.FooterPriceSuccessConfig
import com.miam.sdk.components.price.footer.success.FooterPriceSuccessConfigBuilder

class FooterPriceConfigBuilder {
    var loading : FooterLoadingPriceConfig = FooterLoadingPriceConfig()
    var success : FooterPriceSuccessConfig = FooterPriceSuccessConfig()
    var empty : FooterEmptyPriceConfig = FooterEmptyPriceConfig()

    inline fun loading(init: FooterLoadingPriceConfigBuilder.() -> Unit) {
        loading = FooterLoadingPriceConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun success(init: FooterPriceSuccessConfigBuilder.() -> Unit) {
        success = FooterPriceSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: FooterEmptyPriceConfigBuilder.() -> Unit) {
        empty = FooterEmptyPriceConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): FooterPriceConfig {
        return FooterPriceConfig(loading, success, empty)
    }

}