package com.miam.sdk.components.myMeal.myMealTitle

import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Typography

class MyMealTitleImp: MyMealTitle {
    @Composable
    override fun Content(params: MyMealTitleParameters) {
        Text(
            text = Localisation.MyMeals.mealsInBasket(params.numberOfRecipe).localised,
            style = Typography.subtitleBold,
            modifier = Modifier
                .padding(16.dp)
                .fillMaxWidth(),
            textAlign = TextAlign.Center
        )
    }
}