package com.miam.sdk.components.myMeal.myMealRecipeCard.loading

import androidx.compose.animation.core.FastOutLinearInEasing
import androidx.compose.animation.core.animateFloat
import androidx.compose.animation.core.infiniteRepeatable
import androidx.compose.animation.core.rememberInfiniteTransition
import androidx.compose.animation.core.tween
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Card
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Brush
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp

class MyMealRecipeCardLoadingImp: MyMealRecipeCardLoading {
    @Composable
    override fun Content(params: MyMealRecipeCardLoadingParameters) {
        val shimmerColors = listOf(
            Color.LightGray.copy(alpha = 0.6F),
            Color.LightGray.copy(alpha = 0.2F),
            Color.LightGray.copy(alpha = 0.6F)
        )
        val transition = rememberInfiniteTransition()
        val translateAnimation = transition.animateFloat(
            initialValue = 0f,
            targetValue = 1000f,
            animationSpec = infiniteRepeatable(
                animation = tween(
                    durationMillis = 1000,
                    easing = FastOutLinearInEasing
                )
            )
        )
        val brush = Brush.linearGradient(
            colors = shimmerColors,
            start = Offset.Zero,
            end = Offset(
                x = translateAnimation.value,
                y = translateAnimation.value
            )
        )
        Card(
            modifier = Modifier
                .fillMaxWidth()
                .padding(16.dp)
        ) {
            ShimmerMyMealRecipeCard(brush)
        }
    }
}

@Composable
fun ShimmerMyMealRecipeCard(brush: Brush) {
    Row(
        Modifier
            .height(170.dp)
            .padding(12.dp),
        verticalAlignment = Alignment.CenterVertically
    ) {
        Spacer(
            modifier = Modifier
                .height(140.dp)
                .width(140.dp)
                .clip(RoundedCornerShape(8.dp))
                .background(brush = brush)
        )
        Spacer(modifier = Modifier.width(12.dp))
        Column(
            Modifier
                .fillMaxHeight()
                .fillMaxWidth()
                .padding(vertical = 8.dp),
            verticalArrangement = Arrangement.SpaceBetween
        ) {
            Row(
                horizontalArrangement = Arrangement.SpaceBetween
            ) {
                Spacer(
                    modifier = Modifier
                        .height(24.dp)
                        .width(200.dp)
                        .clip(RoundedCornerShape(100))
                        .background(brush = brush)
                )

                Spacer(
                    modifier = Modifier
                        .height(24.dp)
                        .width(24.dp)
                        .clip(RoundedCornerShape(100))
                        .background(brush = brush)
                )
            }
            Spacer(
                modifier = Modifier
                    .height(8.dp)
                    .width(60.dp)
                    .clip(RoundedCornerShape(100))
                    .background(brush = brush)
            )
            Spacer(
                modifier = Modifier
                    .height(14.dp)
                    .width(160.dp)
                    .clip(RoundedCornerShape(100))
                    .background(brush = brush)
            )

            Spacer(
                modifier = Modifier
                    .height(32.dp)
                    .fillMaxWidth()
                    .clip(RoundedCornerShape(100))
                    .background(brush = brush)
            )
        }
    }
}