package com.miam.sdk.components.myMeal.myMealRecipeCard

import com.miam.sdk.components.myMeal.myMealRecipeCard.loading.MyMealRecipeCardLoadingConfig
import com.miam.sdk.components.myMeal.myMealRecipeCard.loading.MyMealRecipeCardLoadingConfigBuilder
import com.miam.sdk.components.myMeal.myMealRecipeCard.success.MyMealRecipeCardSuccessConfig
import com.miam.sdk.components.myMeal.myMealRecipeCard.success.MyMealRecipeCardSuccessConfigBuilder

class MyMealRecipeCardConfigBuilder {
    var success: MyMealRecipeCardSuccessConfig = MyMealRecipeCardSuccessConfig()
    var loading: MyMealRecipeCardLoadingConfig = MyMealRecipeCardLoadingConfig()

    inline fun success(init: MyMealRecipeCardSuccessConfigBuilder.() -> Unit) {
        this.success = MyMealRecipeCardSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loading(init: MyMealRecipeCardLoadingConfigBuilder.() -> Unit) {
        this.loading = MyMealRecipeCardLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): MyMealRecipeCardConfig {
        return MyMealRecipeCardConfig(
            success, loading
        )
    }
}