package com.miam.sdk.components.mealPlanner.form.success

import com.miam.core.base.state.ComponentUiState
import kotlinx.coroutines.flow.Flow

data class MealPlannerFormSuccessParameters(
    val budget: Int,
    val numberOfGuests: Int,
    val numberOfMeals: Int,
    val uiState: ComponentUiState,
    val setBudget: (Int) -> Unit,
    val setNumberOfGuests: (Int) -> Unit,
    val setNumberOfMeals: (Int) -> Unit,
    val maxMealCount: Int,
    val currentRemainingRecipeCountFlow: Flow<Int>,
    val refreshMaxMealCount: (budget: Int, guestCount: Int) -> Unit,
    val submit: (budget: Int, numberOfMeal: Int, numberOfGuests: Int) -> Unit
)
