package com.miam.sdk.components.mealPlanner.callToAction.success

import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.alpha
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.graphics.painter.Painter
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Dimension
import com.miam.kmm_miam_sdk.android.theme.Typography

class MealPlannerCallToActionSuccessImp: MealPlannerCallToActionSuccess {
    @Composable
    override fun Content(mealPlannerCallToActionParameters: MealPlannerCallToActionSuccessParameters) {
        Box(modifier = Modifier
            .padding(Dimension.lPadding)
            .fillMaxWidth()
            .height(150.dp)
            .clip(RoundedCornerShape(Dimension.mRoundedCorner))
            .clickable { mealPlannerCallToActionParameters.onclick() }
            .background(Color.Black)) {
            val backgroundImage: Painter = painterResource(id = Image.budgetHomeBackground)
            Image(
                painter = backgroundImage,
                contentDescription = null,
                contentScale = ContentScale.FillWidth,
                alignment = Alignment.TopStart,
                modifier = Modifier
                    .fillMaxWidth()
                    .height(150.dp)
                    .alpha(0.6f)
            )
            Column(
                modifier = Modifier
                    .padding(Dimension.lPadding)
                    .fillMaxWidth()
            ) {
                Row(
                    modifier = Modifier.fillMaxSize()
                ) {
                    Column(
                        modifier = Modifier.padding(top = Dimension.xlPadding)
                    ) {
                        Text(
                            text = Localisation.Budget.myBudget.localised, color = Color.White, style = Typography.subtitleBold
                        )
                        Spacer(modifier = Modifier.height(Dimension.sSpacerHeight))
                        Text(
                            text = Localisation.Budget.myBudgetSubtext.localised, color = Color.White, style = Typography.body
                        )
                    }
                    Spacer(modifier = Modifier.weight(1f))
                    val caretImage: Painter = painterResource(id = Image.toggleCaret)
                    Image(
                        painter = caretImage,
                        contentDescription = null,
                        colorFilter = ColorFilter.tint(Color.White),
                        modifier = Modifier
                            .size(Dimension.lIconHeight)
                            .align(Alignment.CenterVertically)
                    )
                }
            }
        }
    }
}