package com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.notInBasketProducts

import androidx.compose.foundation.Image
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Typography

class NotInBasketProductImp: NotInBasketProduct {

    @Composable
    override fun Content(params: NotInBasketProductParameters) {
        Row(
            verticalAlignment = Alignment.CenterVertically,
            horizontalArrangement = Arrangement.SpaceBetween,
            modifier = Modifier
                .padding(vertical = 8.dp, horizontal = 32.dp)
                .fillMaxWidth()
        ) {
            Text(text = params.name, style = Typography.body)
            if (params.canBeAdd) {
                Row(
                    Modifier.clickable { params.add() },
                    verticalAlignment = Alignment.CenterVertically
                ) {
                    Image(
                        painter = painterResource(Image.plus),
                        contentDescription = "add icon",
                        modifier = Modifier.size(14.dp)
                    )
                    Spacer(modifier = Modifier.padding(8.dp))
                    Text(
                        text = Localisation.Basket.addProduct.localised,
                        style = Typography.bodyBold,
                    )
                }
            }
        }
    }
}
