package com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket

import com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.header.NotInBasketProductHeaderConfig
import com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.header.NotInBasketProductHeaderConfigBuilder
import com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.notInBasketProducts.NotInBasketProductConfig
import com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.notInBasketProducts.NotInBasketProductConfigBuilder

class NotInBasketProductsConfigBuilder {

    var header: NotInBasketProductHeaderConfig = NotInBasketProductHeaderConfig()
    var product: NotInBasketProductConfig = NotInBasketProductConfig()

    inline fun header(init: NotInBasketProductHeaderConfigBuilder.() -> Unit) {
        this.header = NotInBasketProductHeaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun product(init: NotInBasketProductConfigBuilder.() -> Unit) {
        this.product = NotInBasketProductConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): NotInBasketProductsConfig {
        return NotInBasketProductsConfig(
            header, product
        )
    }
}