package com.miam.sdk.components.mealPlanner

import com.miam.sdk.components.mealPlanner.basketPreview.MealPlannerBasketPreviewConfig
import com.miam.sdk.components.mealPlanner.basketPreview.MealPlannerBasketPreviewConfigBuilder
import com.miam.sdk.components.mealPlanner.basketPreview.empty.MealPlannerBasketPreviewEmptyConfig
import com.miam.sdk.components.mealPlanner.basketPreview.empty.MealPlannerBasketPreviewEmptyConfigBuilder
import com.miam.sdk.components.mealPlanner.basketPreview.footer.MealPlannerBasketPreviewFooterConfig
import com.miam.sdk.components.mealPlanner.basketPreview.footer.MealPlannerBasketPreviewFooterConfigBuilder
import com.miam.sdk.components.mealPlanner.callToAction.MealPlannerCallToActionConfig
import com.miam.sdk.components.mealPlanner.callToAction.MealPlannerCallToActionConfigBuilder
import com.miam.sdk.components.mealPlanner.form.MealPlannerFormConfig
import com.miam.sdk.components.mealPlanner.form.MealPlannerFormConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.empty.MealPlannerEmptyConfig
import com.miam.sdk.components.mealPlanner.meals.empty.MealPlannerEmptyConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.footer.MealPlannerFooterConfig
import com.miam.sdk.components.mealPlanner.meals.footer.MealPlannerFooterConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.loading.MealPlannerLoadingConfig
import com.miam.sdk.components.mealPlanner.meals.loading.MealPlannerLoadingConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.toolbar.MealPlannerToolbarConfig
import com.miam.sdk.components.mealPlanner.meals.toolbar.MealPlannerToolbarConfigBuilder
import com.miam.sdk.components.mealPlanner.recap.MealPlannerRecapConfig
import com.miam.sdk.components.mealPlanner.recap.MealPlannerRecapConfigBuilder
import com.miam.sdk.components.mealPlanner.recipe.MealPlannerRecipeCardConfig
import com.miam.sdk.components.mealPlanner.recipe.MealPlannerRecipeCardConfigBuilder
import com.miam.sdk.components.mealPlanner.recipe.loading.MealPlannerRecipeLoadingConfig
import com.miam.sdk.components.mealPlanner.recipe.loading.MealPlannerRecipeLoadingConfigBuilder
import com.miam.sdk.components.mealPlanner.recipe.success.placeholder.MealPlannerRecipePlaceholderConfig
import com.miam.sdk.components.mealPlanner.recipe.success.placeholder.MealPlannerRecipePlaceholderConfigBuilder
import com.miam.sdk.components.mealPlanner.search.MealPlannerSearchConfig
import com.miam.sdk.components.mealPlanner.search.MealPlannerSearchConfigBuilder
import com.miam.sdk.components.mealPlanner.search.empty.MealPlannerSearchEmptyConfig
import com.miam.sdk.components.mealPlanner.search.empty.MealPlannerSearchEmptyConfigBuilder

class MealPlannerConfigBuilder {

    var recipeCardConfig: MealPlannerRecipeCardConfig = MealPlannerRecipeCardConfig()
    var recipePlaceholderConfig: MealPlannerRecipePlaceholderConfig = MealPlannerRecipePlaceholderConfig()
    var recipeLoadingConfig: MealPlannerRecipeLoadingConfig = MealPlannerRecipeLoadingConfig()
    var basketPreviewEmptyConfig: MealPlannerBasketPreviewEmptyConfig = MealPlannerBasketPreviewEmptyConfig()
    var basketPreviewFooterConfig: MealPlannerBasketPreviewFooterConfig = MealPlannerBasketPreviewFooterConfig()
    var callToActionConfig: MealPlannerCallToActionConfig = MealPlannerCallToActionConfig()
    var formConfig: MealPlannerFormConfig = MealPlannerFormConfig()
    var searchConfig: MealPlannerSearchConfig = MealPlannerSearchConfig()
    var searchEmpty: MealPlannerSearchEmptyConfig = MealPlannerSearchEmptyConfig()
    var recapConfig: MealPlannerRecapConfig = MealPlannerRecapConfig()
    var plannerEmptyConfig: MealPlannerEmptyConfig = MealPlannerEmptyConfig()
    var plannerFooterConfig: MealPlannerFooterConfig = MealPlannerFooterConfig()
    var plannerLoadingConfig: MealPlannerLoadingConfig = MealPlannerLoadingConfig()
    var plannerToolbarConfig: MealPlannerToolbarConfig = MealPlannerToolbarConfig()
    var basketPreview: MealPlannerBasketPreviewConfig = MealPlannerBasketPreviewConfig()


    inline fun basketPreview(init: MealPlannerBasketPreviewConfigBuilder.() -> Unit) {
        this.basketPreview = MealPlannerBasketPreviewConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipeCardConfig(init: MealPlannerRecipeCardConfigBuilder.() -> Unit) {
        this.recipeCardConfig = MealPlannerRecipeCardConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipePlaceholderConfig(init: MealPlannerRecipePlaceholderConfigBuilder.() -> Unit) {
        this.recipePlaceholderConfig = MealPlannerRecipePlaceholderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipeLoadingConfig(init: MealPlannerRecipeLoadingConfigBuilder.() -> Unit) {
        this.recipeLoadingConfig = MealPlannerRecipeLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun basketPreviewFooterConfig(init: MealPlannerBasketPreviewFooterConfigBuilder.() -> Unit) {
        this.basketPreviewFooterConfig = MealPlannerBasketPreviewFooterConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun callToActionConfig(init: MealPlannerCallToActionConfigBuilder.() -> Unit) {
        this.callToActionConfig = MealPlannerCallToActionConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun formConfig(init: MealPlannerFormConfigBuilder.() -> Unit) {
        this.formConfig = MealPlannerFormConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun basketPreviewEmptyConfig(init: MealPlannerBasketPreviewEmptyConfigBuilder.() -> Unit) {
        this.basketPreviewEmptyConfig = MealPlannerBasketPreviewEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun searchEmpty(init: MealPlannerSearchEmptyConfigBuilder.() -> Unit) {
        this.searchEmpty = MealPlannerSearchEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recapConfig(init: MealPlannerRecapConfigBuilder.() -> Unit) {
        this.recapConfig = MealPlannerRecapConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun searchConfig(init: MealPlannerSearchConfigBuilder.() -> Unit) {
        this.searchConfig = MealPlannerSearchConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerEmptyConfig(init: MealPlannerEmptyConfigBuilder.() -> Unit) {
        this.plannerEmptyConfig = MealPlannerEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerFooterConfig(init: MealPlannerFooterConfigBuilder.() -> Unit) {
        this.plannerFooterConfig = MealPlannerFooterConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerLoadingConfig(init: MealPlannerLoadingConfigBuilder.() -> Unit) {
        this.plannerLoadingConfig = MealPlannerLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun plannerToolbarConfig(init: MealPlannerToolbarConfigBuilder.() -> Unit) {
        this.plannerToolbarConfig = MealPlannerToolbarConfigBuilder()
            .apply(init)
            .build()
    }


    @PublishedApi
    internal fun build(): MealPlannerConfig {
        return MealPlannerConfig(
            basketPreview,
            recipeCardConfig,
            recipePlaceholderConfig,
            recipeLoadingConfig,
            basketPreviewEmptyConfig,
            basketPreviewFooterConfig,
            callToActionConfig,
            plannerEmptyConfig,
            plannerFooterConfig,
            plannerLoadingConfig,
            plannerToolbarConfig,
            formConfig,
            searchEmpty,
            searchConfig,
            recapConfig
        )
    }
}