package com.miam.sdk.components.catalog.success

import com.miam.core.model.Package
import com.miam.core.viewModels.catalog.CatalogContent

data class CatalogSuccessParameters(
    val categories: List<Package>,
    val content: CatalogContent,
    val openFilter: () -> Unit,
    val openSearch: () -> Unit,
    val openPreferences: () -> Unit,
    val getActiveFilterCount: () -> Int,
    val onPrevious: () -> Unit,
    val onGoToFavorite: () -> Unit,
    val onGoToCategoryPage: (id: String, title: String, subtitle: String?) -> Unit,
    val search: (CatalogContent) -> Unit,
    val onGoToMealPlanner: (() -> Unit)? = null,

    val catId: String? = null,
    val catTitle: String? = null,
    val catSubtitle: String? = null
)