package com.miam.sdk.components.baseComponent.recipesPage.success

import com.miam.sdk.components.baseComponent.lazyListLoader.LazyListLoaderConfig
import com.miam.sdk.components.baseComponent.lazyListLoader.LazyListLoaderConfigBuilder
import com.miam.sdk.components.baseComponent.recipesPage.success.title.RecipesPageSuccessTitleConfig
import com.miam.sdk.components.baseComponent.recipesPage.success.title.RecipesPageSuccessTitleConfigBuilder

class RecipesPageSuccessConfigBuilder {

    var title: RecipesPageSuccessTitleConfig = RecipesPageSuccessTitleConfig()
    var lazyFetchLoader: LazyListLoaderConfig = LazyListLoaderConfig()
    var catalogPageColumns: Int = 1
    var catalogPageVerticalSpacing: Int = 12
    var catalogPageHorizontalSpacing: Int = 12

    inline fun title(init: RecipesPageSuccessTitleConfigBuilder.() -> Unit) {
        this.title = RecipesPageSuccessTitleConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun lazyFetchLoader(init: LazyListLoaderConfigBuilder.() -> Unit) {
        this.lazyFetchLoader = LazyListLoaderConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): RecipesPageSuccessConfig {
        return RecipesPageSuccessConfig(title, lazyFetchLoader, catalogPageColumns, catalogPageVerticalSpacing, catalogPageHorizontalSpacing)
    }

}
