package com.miam.sdk.components.baseComponent.likeButton.success

import androidx.compose.animation.Crossfade
import androidx.compose.animation.core.tween
import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.Surface
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.ressource.Image.favorite
import com.miam.kmm_miam_sdk.android.ressource.Image.favoriteFilled
import com.miam.kmm_miam_sdk.android.theme.Colors

class LikeButtonSuccessImp: LikeButtonSuccess {
    @Composable
    override fun Content(param: LikeButtonSuccessParameters) {
        val isLiked by remember { mutableStateOf(param.isLiked) }
        Surface(shape = param.backgroundShape) {
            Box(
                Modifier
                    .background(Colors.white)
                    .padding(8.dp)
                    .clickable { param.likeAction() }
            ) {
                Crossfade(targetState = isLiked, animationSpec = tween(750, 0), label = "Fading 750ms") { currentIsLiked ->
                    if (currentIsLiked) {
                        Image(
                            painter = painterResource(favoriteFilled),
                            contentDescription = "favorite filled",
                            modifier = Modifier.size(20.dp)
                                .padding(start = 2.dp),
                        )
                    } else {
                        Image(
                            painter = painterResource(favorite),
                            contentDescription = "favorite unfilled",
                            modifier = Modifier.size(20.dp)
                                .padding(start = 2.dp),
                        )
                    }
                }
            }
        }
    }
}