package com.miam.sdk.components.baseComponent.lazyListLoader

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.CircularProgressIndicator
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.theme.Colors

class LazyListLoaderImp: LazyListLoader {
    @Composable
    override fun Content(params: LazyListLoaderParameters) {

        Row(
            modifier = Modifier
                .fillMaxWidth()
                .padding(vertical = 4.dp),
            horizontalArrangement = Arrangement.Center
        ) {
            if (params.isFetching){
                CircularProgressIndicator(
                    color = Colors.primary
                )
            }
        }
    }
}