package com.miam.sdk.components.recipeDetail.success.product

import androidx.compose.foundation.layout.Box
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import com.miam.core.base.state.ComponentUiState
import com.miam.core.viewModels.product.ProductContract
import com.miam.core.viewModels.product.ProductViewModel
import com.miam.sdk.components.price.formatPrice
import com.miam.sdk.components.recipeDetail.success.product.ignore.ProductIgnoreParameters
import com.miam.sdk.components.recipeDetail.success.product.loading.ProductLoadingParameters
import com.miam.sdk.components.recipeDetail.success.product.success.ProductSuccessParameters
import com.miam.sdk.di.TemplateDI
import kotlinx.coroutines.flow.MutableStateFlow

@Composable
fun Products(productsVm: MutableStateFlow<List<ProductViewModel>>, defaultRecipeGuest: Int, guest: MutableStateFlow<Int>) {
    val productsVmState by productsVm.collectAsState()


    productsVmState.forEach() { productVM ->
        val productState by productVM.uiState.collectAsState()
        val productQuantity by productVM.productQtySubject.collectAsState()
        DisposableEffect(Unit) { onDispose {
            productVM.dispose()
        } }

        LaunchedEffect(Unit) {
            productVM.registerListeners()
        }
        when (productState.status) {
            ComponentUiState.LOADING -> {
                TemplateDI.recipeDetail.success.product.loading.view.Content(
                    ProductLoadingParameters
                )
            }

            ComponentUiState.SUCCESS, ComponentUiState.LOCKED -> {
                productState.ingredient?.let { ingredient ->
                    productState.basketEntry?.let { basketEntry ->
                        basketEntry.selectedItem?.attributes?.let { selectedItemAttributes ->
                            when (basketEntry.attributes?.status ?: "no status") {
                                "initial", "active" -> TemplateDI.recipeDetail.success.product.success.view.Content(
                                    ProductSuccessParameters(
                                        productName = selectedItemAttributes.name,
                                        productBrand = selectedItemAttributes.brand ?: "",
                                        productCapacityVolume = selectedItemAttributes.capacityVolume ?: "Attribute no found",
                                        productQuantity = productQuantity,
                                        productUnit = selectedItemAttributes.capacityUnit ?: "Attribute no found",
                                        productPrice = basketEntry.unitPrice.formatPrice(),
                                        productImage = selectedItemAttributes.image ?: "Attribute no found",
                                        ingredientName = ingredient.name,
                                        ingredientQuantity = ingredient.attributes?.quantity ?: "Attribute no found",
                                        ingredientUnit = ingredient.attributes?.unit ?: "Attribute no found",
                                        guestsCount = guest,
                                        defaultRecipeGuest = defaultRecipeGuest,
                                        isLocked = productState.status == ComponentUiState.LOCKED,
                                        isSponsored = productVM.isSponsored(),
                                        isInBasket = basketEntry.isInBasket,
                                        numberOfRecipeConcernsByProduct = basketEntry.attributes?.recipeIds?.size ?: 0,
                                        ean = selectedItemAttributes.ean,
                                        addProduct = { productVM.setEvent(ProductContract.Event.AddProduct) },
                                        replaceProduct = { productVM.setEvent(ProductContract.Event.ReplaceProduct) },
                                        ignoreProduct = { productVM.setEvent(ProductContract.Event.IgnoreIngredient) },
                                        updateProductQuantity = { productVM.setEvent(ProductContract.Event.UpdateProductQty(it)) }
                                    )
                                )
                                "ignored", "deleted" -> TemplateDI.recipeDetail.success.product.ignore.view.Content(
                                    ProductIgnoreParameters(
                                        ingredientName = ingredient.name,
                                        ingredientQuantity = ingredient.attributes?.quantity ?: "Attribute no found",
                                        ingredientUnit = ingredient.attributes?.unit ?: "Attribute no found",
                                        guestsCount = guest,
                                        defaultRecipeGuest = defaultRecipeGuest,
                                        chooseProduct = { productVM.setEvent(ProductContract.Event.ReplaceProduct) }
                                    )
                                )
                                else -> Box {}
                            }
                        }

                    }
                }
            }

            else -> {
                Box {

                }
            }
        }
    }
}