package com.miam.sdk.components.recipeDetail.success.product

import com.miam.sdk.components.recipeDetail.success.product.ignore.ProductIgnoreConfig
import com.miam.sdk.components.recipeDetail.success.product.ignore.ProductIgnoreConfigBuilder
import com.miam.sdk.components.recipeDetail.success.product.loading.ProductLoadingConfig
import com.miam.sdk.components.recipeDetail.success.product.loading.ProductLoadingConfigBuilder
import com.miam.sdk.components.recipeDetail.success.product.success.ProductSuccessConfig
import com.miam.sdk.components.recipeDetail.success.product.success.ProductSuccessConfigBuilder

class ProductConfigBuilder {
    var success: ProductSuccessConfig = ProductSuccessConfig()
    var loading: ProductLoadingConfig = ProductLoadingConfig()
    var ignore: ProductIgnoreConfig = ProductIgnoreConfig()

    inline fun success(init: ProductSuccessConfigBuilder.() -> Unit) {
        this.success = ProductSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loading(init: ProductLoadingConfigBuilder.() -> Unit) {
        this.loading = ProductLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun ignore(init: ProductIgnoreConfigBuilder.() -> Unit) {
        this.ignore = ProductIgnoreConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): ProductConfig {
        return ProductConfig(success, loading, ignore)
    }
}