package com.miam.sdk.components.itemSelector

import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfig
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfigBuilder
import com.miam.sdk.components.itemSelector.header.ItemSelectorHeaderConfig
import com.miam.sdk.components.itemSelector.header.ItemSelectorHeaderConfigBuilder
import com.miam.sdk.components.itemSelector.loading.ItemSelectorLoadingConfig
import com.miam.sdk.components.itemSelector.loading.ItemSelectorLoadingConfigBuilder
import com.miam.sdk.components.itemSelector.search.ItemSelectorSearchConfig
import com.miam.sdk.components.itemSelector.search.ItemSelectorSearchConfigBuilder
import com.miam.sdk.components.itemSelector.selectedItem.ItemSelectorSelectedItemConfig
import com.miam.sdk.components.itemSelector.selectedItem.ItemSelectorSelectedItemConfigBuilder
import com.miam.sdk.components.itemSelector.success.ItemSelectorSuccessConfig
import com.miam.sdk.components.itemSelector.success.ItemSelectorSuccessConfigBuilder

class ItemSelectorConfigBuilder {
    var success: ItemSelectorSuccessConfig = ItemSelectorSuccessConfig()
    var loading: ItemSelectorLoadingConfig = ItemSelectorLoadingConfig()
    var empty: EmptyPageConfig? = null
    var header: ItemSelectorHeaderConfig = ItemSelectorHeaderConfig()
    var search: ItemSelectorSearchConfig = ItemSelectorSearchConfig()
    var selectedItem: ItemSelectorSelectedItemConfig = ItemSelectorSelectedItemConfig()


    inline fun success(init: ItemSelectorSuccessConfigBuilder.() -> Unit) {
        this.success = ItemSelectorSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loading(init: ItemSelectorLoadingConfigBuilder.() -> Unit) {
        this.loading = ItemSelectorLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun header(init: ItemSelectorHeaderConfigBuilder.() -> Unit) {
        this.header = ItemSelectorHeaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun search(init: ItemSelectorSearchConfigBuilder.() -> Unit) {
        this.search = ItemSelectorSearchConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun selectedItem(init: ItemSelectorSelectedItemConfigBuilder.() -> Unit) {
        this.selectedItem = ItemSelectorSelectedItemConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: EmptyPageConfigBuilder.() -> Unit) {
        this.empty = EmptyPageConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): ItemSelectorConfig {
        return ItemSelectorConfig(header, search, selectedItem, success, loading, empty)
    }
}