package com.miam.sdk.components.baseComponent.recipesPage.success

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.lazy.grid.GridCells
import androidx.compose.foundation.lazy.grid.GridItemSpan
import androidx.compose.foundation.lazy.grid.LazyVerticalGrid
import androidx.compose.foundation.lazy.grid.itemsIndexed
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.miam.core.model.Recipe
import com.miam.sdk.components.baseComponent.recipesPage.success.title.RecipesPageSuccessTitleParameters
import com.miam.sdk.components.recipeJourney.RecipeJourney
import com.miam.sdk.di.TemplateDI

@Composable
fun RecipesPageSuccess(
    title: String,
    recipes: List<Recipe>,
    isFetching: Boolean,
    loadPage: () -> Unit
) {
    Box(modifier = Modifier.fillMaxSize()) {
        LazyVerticalGrid(
            modifier = Modifier.fillMaxSize(),
            columns = GridCells.Fixed(TemplateDI.recipesPage.success.numberOfColumns),
            verticalArrangement = Arrangement.spacedBy(TemplateDI.recipesPage.success.verticalSpacing.dp, Alignment.Top),
            horizontalArrangement = Arrangement.spacedBy(TemplateDI.recipesPage.success.horizontalSpacing.dp, Alignment.Start)
        ) {
            item(span = { GridItemSpan(TemplateDI.recipesPage.success.numberOfColumns) }) {
                TemplateDI.recipesPage.success.title.view.Content(
                    params = RecipesPageSuccessTitleParameters(title)
                )
            }
            itemsIndexed(recipes, { _, recipe -> recipe.id }) { index, recipe ->
                RecipeJourney.View(recipe = recipe)
                if (index == recipes.lastIndex) {
                    loadPage()
                }
            }
            item(span = { GridItemSpan(TemplateDI.recipesPage.success.numberOfColumns) }) {
                TemplateDI.recipesPage.success.lazyFetchLoader.view.Content(
                    params = com.miam.sdk.components.baseComponent.lazyListLoader.LazyListLoaderParameters(
                        isFetching
                    )
                )
            }
        }
    }
}