package com.miam.sdk.components.baseComponent.likeButton

import com.miam.sdk.components.baseComponent.likeButton.loading.LikeButtonLoadingConfig
import com.miam.sdk.components.baseComponent.likeButton.loading.LikeButtonLoadingConfigBuilder
import com.miam.sdk.components.baseComponent.likeButton.success.LikeButtonSuccessConfig
import com.miam.sdk.components.baseComponent.likeButton.success.LikeButtonSuccessConfigBuilder

class LikeButtonConfigBuilder {
    var success: LikeButtonSuccessConfig = LikeButtonSuccessConfig()
    var loading: LikeButtonLoadingConfig = LikeButtonLoadingConfig()

    inline fun success(init: LikeButtonSuccessConfigBuilder.() -> Unit) {
        success = LikeButtonSuccessConfigBuilder().apply(init).build()
    }

    inline fun loading(init: LikeButtonLoadingConfigBuilder.() -> Unit) {
        loading = LikeButtonLoadingConfigBuilder().apply(init).build()
    }

    @PublishedApi
    internal fun build(): LikeButtonConfig {
        return LikeButtonConfig(success, loading)
    }
}