package com.miam.sdk.components

import com.miam.sdk.components.baseComponent.DefaultViewsConfig
import com.miam.sdk.components.baseComponent.DefaultViewsConfigBuilder
import com.miam.sdk.components.baseComponent.filter.FilterConfig
import com.miam.sdk.components.baseComponent.filter.FilterConfigBuilder
import com.miam.sdk.components.baseComponent.likeButton.LikeButtonConfig
import com.miam.sdk.components.baseComponent.likeButton.LikeButtonConfigBuilder
import com.miam.sdk.components.baseComponent.myMealButton.MyMealButtonConfig
import com.miam.sdk.components.baseComponent.myMealButton.MyMealButtonConfigBuilder
import com.miam.sdk.components.baseComponent.recipesPage.RecipesPageConfig
import com.miam.sdk.components.baseComponent.recipesPage.RecipesPageConfigBuilder
import com.miam.sdk.components.catalog.CatalogConfig
import com.miam.sdk.components.catalog.CatalogConfigBuilder
import com.miam.sdk.components.favoritePage.FavoritePageConfig
import com.miam.sdk.components.favoritePage.FavoritePageConfigBuilder
import com.miam.sdk.components.itemSelector.ItemSelectorConfig
import com.miam.sdk.components.itemSelector.ItemSelectorConfigBuilder
import com.miam.sdk.components.mealPlanner.MealPlannerConfig
import com.miam.sdk.components.mealPlanner.MealPlannerConfigBuilder
import com.miam.sdk.components.mealPlanner.callToAction.MealPlannerCallToActionConfig
import com.miam.sdk.components.mealPlanner.callToAction.MealPlannerCallToActionConfigBuilder
import com.miam.sdk.components.myMeal.MyMealConfig
import com.miam.sdk.components.myMeal.MyMealConfigBuilder
import com.miam.sdk.components.preferences.PreferencesConfig
import com.miam.sdk.components.preferences.PreferencesConfigBuilder
import com.miam.sdk.components.price.PriceConfig
import com.miam.sdk.components.price.PriceConfigBuilder
import com.miam.sdk.components.recipeCard.RecipeCardConfig
import com.miam.sdk.components.recipeCard.RecipeCardConfigBuilder
import com.miam.sdk.components.recipeCarousel.RecipeCarouselConfig
import com.miam.sdk.components.recipeCarousel.RecipeCarouselConfigBuilder
import com.miam.sdk.components.recipeDetail.RecipeDetailConfig
import com.miam.sdk.components.recipeDetail.RecipeDetailConfigBuilder
import com.miam.sdk.components.sponsorDetail.SponsorDetailConfig
import com.miam.sdk.components.sponsorDetail.SponsorDetailConfigBuilder
import com.miam.sdk.components.tag.BasketTagConfig
import com.miam.sdk.components.tag.BasketTagConfigBuilder


object MiamTheme {
    @Suppress("FunctionName")
    inline fun Template(init: MiamThemeBuilder.() -> Unit) {
        MiamThemeBuilder()
            .apply(init)
            .build()
    }

    inline fun MiamThemeBuilder.mealPlanner(init: MealPlannerConfigBuilder.() -> Unit) {
        this.mealPlanner = MealPlannerConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.catalog(init: CatalogConfigBuilder.() -> Unit) {
        this.catalog = CatalogConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.itemSelector(init: ItemSelectorConfigBuilder.() -> Unit) {
        this.itemSelector = ItemSelectorConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.likeButton(init: LikeButtonConfigBuilder.() -> Unit) {
        this.likeButton = LikeButtonConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.favoritePage(init: FavoritePageConfigBuilder.() -> Unit) {
        this.favoritePage = FavoritePageConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.myMeal(init: MyMealConfigBuilder.() -> Unit) {
        this.myMeal = MyMealConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.recipeDetail(init: RecipeDetailConfigBuilder.() -> Unit) {
        this.recipeDetail = RecipeDetailConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.preferences(init: PreferencesConfigBuilder.() -> Unit) {
        this.preferences = PreferencesConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.myMealButton(init: MyMealButtonConfigBuilder.() -> Unit) {
        this.myMealButton = MyMealButtonConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.recipeCard(init: RecipeCardConfigBuilder.() -> Unit) {
        this.recipeCard = RecipeCardConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.basketTag(init: BasketTagConfigBuilder.() -> Unit) {
        this.basketTag = BasketTagConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.price(init: PriceConfigBuilder.() -> Unit) {
        this.price = PriceConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.sponsorDetail(init: SponsorDetailConfigBuilder.() -> Unit) {
        this.sponsorDetail = SponsorDetailConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.recipeCarousel(init: RecipeCarouselConfigBuilder.() -> Unit) {
        this.recipeCarousel = RecipeCarouselConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.defaultViews(init: DefaultViewsConfigBuilder.() -> Unit) {
        this.defaultViews = DefaultViewsConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.recipesPage(init: RecipesPageConfigBuilder.() -> Unit) {
        this.recipesPage = RecipesPageConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.filter(init: FilterConfigBuilder.() -> Unit) {
        this.filter = FilterConfigBuilder().apply(init).build()
    }

    inline fun MiamThemeBuilder.mealPlannerCallToAction(init: MealPlannerCallToActionConfigBuilder.() -> Unit) {
        this.mealPlannerCallToAction = MealPlannerCallToActionConfigBuilder().apply(init).build()
    }
}

class MiamThemeBuilder {

    var mealPlanner: MealPlannerConfig = MealPlannerConfig()
    var catalog: CatalogConfig = CatalogConfig()
    var itemSelector: ItemSelectorConfig = ItemSelectorConfig()
    var likeButton: LikeButtonConfig = LikeButtonConfig()
    var favoritePage: FavoritePageConfig = FavoritePageConfig()
    var recipeDetail: RecipeDetailConfig = RecipeDetailConfig()
    var preferences: PreferencesConfig = PreferencesConfig()
    var price: PriceConfig = PriceConfig()
    var myMeal: MyMealConfig = MyMealConfig()
    var myMealButton: MyMealButtonConfig = MyMealButtonConfig()
    var recipeCard: RecipeCardConfig = RecipeCardConfig()
    var basketTag: BasketTagConfig = BasketTagConfig()
    var sponsorDetail: SponsorDetailConfig = SponsorDetailConfig()
    var recipeCarousel: RecipeCarouselConfig = RecipeCarouselConfig()
    var defaultViews: DefaultViewsConfig = DefaultViewsConfig()
    var recipesPage: RecipesPageConfig = RecipesPageConfig()
    var filter: FilterConfig = FilterConfig()
    var mealPlannerCallToAction: MealPlannerCallToActionConfig = MealPlannerCallToActionConfig()

    @PublishedApi
    internal fun build() {
        TemplatesConfigs.initialise(
            mealPlanner = mealPlanner,
            catalog = catalog,
            itemSelector = itemSelector,
            likeButton = likeButton,
            favoritePage = favoritePage,
            recipeDetail = recipeDetail,
            preferences = preferences,
            myMeal = myMeal,
            myMealButton = myMealButton,
            recipeCard = recipeCard,
            basketTag = basketTag,
            price = price,
            sponsorDetail = sponsorDetail,
            recipeCarousel = recipeCarousel,
            defaultViews = defaultViews,
            recipesPage = recipesPage,
            filter = filter,
            mealPlannerCallToAction = mealPlannerCallToAction
        )
    }
}

internal class TemplatesConfigs private constructor(
    val mealPlanner: MealPlannerConfig,
    val catalog: CatalogConfig,
    val itemSelector: ItemSelectorConfig,
    val likeButton: LikeButtonConfig,
    val favoritePage: FavoritePageConfig,
    val recipeDetail: RecipeDetailConfig,
    val preferences: PreferencesConfig,
    val myMeal: MyMealConfig,
    val myMealButton: MyMealButtonConfig,
    val recipeCard: RecipeCardConfig,
    val basketTag: BasketTagConfig,
    val price: PriceConfig,
    val sponsorDetail: SponsorDetailConfig,
    val recipeCarousel: RecipeCarouselConfig,
    val defaultViews: DefaultViewsConfig,
    val recipesPage: RecipesPageConfig,
    val filter: FilterConfig,
    val mealPlannerCallToAction: MealPlannerCallToActionConfig
) {

    companion object {
        private var templatesConfigs: TemplatesConfigs? = null
            set(value) {
                require(field == null) { "You cannot configure the Templates Configs  twice." }
                field = value
            }

        @PublishedApi
        internal fun initialise(
            mealPlanner: MealPlannerConfig = MealPlannerConfig(),
            catalog: CatalogConfig = CatalogConfig(),
            itemSelector: ItemSelectorConfig = ItemSelectorConfig(),
            likeButton: LikeButtonConfig = LikeButtonConfig(),
            favoritePage: FavoritePageConfig = FavoritePageConfig(),
            recipeDetail: RecipeDetailConfig = RecipeDetailConfig(),
            preferences: PreferencesConfig = PreferencesConfig(),
            myMeal: MyMealConfig = MyMealConfig(),
            recipeCard: RecipeCardConfig = RecipeCardConfig(),
            basketTag: BasketTagConfig = BasketTagConfig(),
            price: PriceConfig = PriceConfig(),
            myMealButton: MyMealButtonConfig = MyMealButtonConfig(),
            sponsorDetail: SponsorDetailConfig = SponsorDetailConfig(),
            recipeCarousel: RecipeCarouselConfig = RecipeCarouselConfig(),
            defaultViews: DefaultViewsConfig = DefaultViewsConfig(),
            recipesPage: RecipesPageConfig = RecipesPageConfig(),
            filter: FilterConfig = FilterConfig(),
            mealPlannerCallToAction: MealPlannerCallToActionConfig = MealPlannerCallToActionConfig()
        ): TemplatesConfigs {
            val tc = TemplatesConfigs(
                mealPlanner,
                catalog,
                itemSelector,
                likeButton,
                favoritePage,
                recipeDetail,
                preferences,
                myMeal,
                myMealButton,
                recipeCard,
                basketTag,
                price,
                sponsorDetail,
                recipeCarousel,
                defaultViews,
                recipesPage,
                filter,
                mealPlannerCallToAction
            )
            templatesConfigs = tc
            return tc
        }

        fun getInstance() = templatesConfigs ?: initialise()
    }
}