package com.miam.sdk.components.recipeDetail

import com.miam.sdk.components.baseComponent.loader.LoaderConfig
import com.miam.sdk.components.baseComponent.loader.LoaderConfigBuilder
import com.miam.sdk.components.recipeDetail.success.RecipeDetailSuccessConfig
import com.miam.sdk.components.recipeDetail.success.RecipeDetailSuccessConfigBuilder

class RecipeDetailConfigBuilder {

    var loading: LoaderConfig? = null
    var success: RecipeDetailSuccessConfig = RecipeDetailSuccessConfig()

    inline fun loading(init: LoaderConfigBuilder.() -> Unit) {
        this.loading = LoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun success(init: RecipeDetailSuccessConfigBuilder.() -> Unit) {
        this.success = RecipeDetailSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): RecipeDetailConfig {
        return RecipeDetailConfig(success, loading)
    }
}