package com.miam.sdk.components.price.loading

import androidx.compose.animation.core.FastOutLinearInEasing
import androidx.compose.animation.core.animateFloat
import androidx.compose.animation.core.infiniteRepeatable
import androidx.compose.animation.core.rememberInfiniteTransition
import androidx.compose.animation.core.tween
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Brush
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Dimension
import com.miam.kmm_miam_sdk.android.theme.Typography

class LoadingPriceImp : LoadingPrice {
    @Composable
    override fun Content() {
        val shimerColors = listOf(
            Colors.lightgrey.copy(alpha = 0.6F), Colors.lightgrey.copy(alpha = 0.2F), Colors.lightgrey.copy(alpha = 0.6F)
        )
        val transition = rememberInfiniteTransition()
        val translateAnimation = transition.animateFloat(
            initialValue = 0f, targetValue = 1000f, animationSpec = infiniteRepeatable(
                animation = tween(
                    durationMillis = 1000, easing = FastOutLinearInEasing
                )
            )
        )
        val brush = Brush.linearGradient(
            colors = shimerColors, start = Offset.Zero, end = Offset(
                x = translateAnimation.value, y = translateAnimation.value
            )
        )
        ShimmerPriceItem(brush)
    }
}

@Composable
fun ShimmerPriceItem(brush: Brush) {
    Column(
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        Row {
            Spacer(
                modifier = Modifier
                    .padding(vertical = Dimension.sPadding)
                    .height(22.dp)
                    .width(Dimension.sSpacerWidth)
                    .clip(RoundedCornerShape(Dimension.mRoundedCorner))
                    .background(brush = brush)
            )
        }
        Text(
            Localisation.Price.perGuest.localised, color = Colors.grey, style = Typography.bodySmall
        )
    }
}