package com.miam.sdk.components.preferences.success

import com.miam.sdk.components.preferences.success.dietSection.PreferencesDietSectionConfig
import com.miam.sdk.components.preferences.success.dietSection.PreferencesDietSectionConfigBuilder
import com.miam.sdk.components.preferences.success.equipmentSection.PreferencesEquipmentSectionConfig
import com.miam.sdk.components.preferences.success.equipmentSection.PreferencesEquipmentSectionConfigBuilder
import com.miam.sdk.components.preferences.success.footer.PreferencesFooterConfig
import com.miam.sdk.components.preferences.success.footer.PreferencesFooterConfigBuilder
import com.miam.sdk.components.preferences.success.guestSection.PreferencesGuestSectionConfig
import com.miam.sdk.components.preferences.success.guestSection.PreferencesGuestSectionConfigBuilder
import com.miam.sdk.components.preferences.success.header.PreferencesSuccessHeaderConfig
import com.miam.sdk.components.preferences.success.header.PreferencesSuccessHeaderConfigBuilder
import com.miam.sdk.components.preferences.success.ingredientSection.PreferencesIngredientSectionConfig
import com.miam.sdk.components.preferences.success.ingredientSection.PreferencesIngredientSectionConfigBuilder

class PreferencesSuccessConfigBuilder {

    var header: PreferencesSuccessHeaderConfig = PreferencesSuccessHeaderConfig()
    var guestSection: PreferencesGuestSectionConfig = PreferencesGuestSectionConfig()
    var dietSection: PreferencesDietSectionConfig = PreferencesDietSectionConfig()
    var ingredientSection: PreferencesIngredientSectionConfig = PreferencesIngredientSectionConfig()
    var equipmentSection: PreferencesEquipmentSectionConfig = PreferencesEquipmentSectionConfig()
    var footer: PreferencesFooterConfig = PreferencesFooterConfig()

    inline fun header(init: PreferencesSuccessHeaderConfigBuilder.() -> Unit) {
        this.header = PreferencesSuccessHeaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun guestSection(init: PreferencesGuestSectionConfigBuilder.() -> Unit) {
        this.guestSection = PreferencesGuestSectionConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun dietSection(init: PreferencesDietSectionConfigBuilder.() -> Unit) {
        this.dietSection = PreferencesDietSectionConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun ingredientSection(init: PreferencesIngredientSectionConfigBuilder.() -> Unit) {
        this.ingredientSection = PreferencesIngredientSectionConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun equipmentSection(init: PreferencesEquipmentSectionConfigBuilder.() -> Unit) {
        this.equipmentSection = PreferencesEquipmentSectionConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun footer(init: PreferencesFooterConfigBuilder.() -> Unit) {
        this.footer = PreferencesFooterConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): PreferencesSuccessConfig {
        return PreferencesSuccessConfig(
            header,
            guestSection,
            dietSection,
            ingredientSection,
            equipmentSection,
            footer
        )
    }
}