package com.miam.sdk.components.preferences.search

import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfig
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfigBuilder
import com.miam.sdk.components.baseComponent.loader.LoaderConfig
import com.miam.sdk.components.baseComponent.loader.LoaderConfigBuilder
import com.miam.sdk.components.preferences.search.field.PreferencesSearchFieldConfig
import com.miam.sdk.components.preferences.search.field.PreferencesSearchFieldConfigBuilder
import com.miam.sdk.components.preferences.search.success.PreferenceSearchSuccessConfig
import com.miam.sdk.components.preferences.search.success.PreferenceSearchSuccessConfigBuilder

class PreferencesSearchConfigBuilder {

    var field: PreferencesSearchFieldConfig = PreferencesSearchFieldConfig()
    var loading: LoaderConfig? = null
    var empty: EmptyPageConfig? = null
    var success: PreferenceSearchSuccessConfig = PreferenceSearchSuccessConfig()

    inline fun field(init: PreferencesSearchFieldConfigBuilder.() -> Unit) {
        this.field = PreferencesSearchFieldConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loading(init: LoaderConfigBuilder.() -> Unit) {
        this.loading = LoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: EmptyPageConfigBuilder.() -> Unit) {
        this.empty = EmptyPageConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun success(init: PreferenceSearchSuccessConfigBuilder.() -> Unit) {
        this.success = PreferenceSearchSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): PreferencesSearchConfig {
        return PreferencesSearchConfig(field, loading, empty, success)
    }
}