package com.miam.sdk.components.myMeal

import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfig
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfigBuilder
import com.miam.sdk.components.baseComponent.loader.LoaderConfig
import com.miam.sdk.components.baseComponent.loader.LoaderConfigBuilder
import com.miam.sdk.components.myMeal.myMealRecipeCard.MyMealRecipeCardConfig
import com.miam.sdk.components.myMeal.myMealRecipeCard.MyMealRecipeCardConfigBuilder

class MyMealConfigBuilder {
    var loading: LoaderConfig? = null
    var empty: EmptyPageConfig? = null
    var recipeCard: MyMealRecipeCardConfig = MyMealRecipeCardConfig()

    inline fun loading(init: LoaderConfigBuilder.() -> Unit) {
        this.loading = LoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: EmptyPageConfigBuilder.() -> Unit) {
        this.empty = EmptyPageConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipeCard(init: MyMealRecipeCardConfigBuilder.() -> Unit) {
        this.recipeCard = MyMealRecipeCardConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): MyMealConfig {
        return MyMealConfig(
            loading,
            empty,
            recipeCard
        )
    }
}