package com.miam.sdk.components.mealPlanner.callToAction

import android.content.Context
import android.util.AttributeSet
import androidx.compose.runtime.Composable
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.sdk.components.mealPlanner.callToAction.success.MealPlannerCallToActionSuccessParameters
import com.miam.sdk.di.TemplateDI

class MealPlannerCallToAction @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    private var onclick = {}

    fun bind(onclick: () -> Unit) {
        this.onclick = onclick
    }

    @Composable
    override fun Content() {
        TemplateDI.mealPlanner.callToAction.success.view.Content(params = MealPlannerCallToActionSuccessParameters {
            onclick()
        })
    }
}